/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.DynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.IDynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;

public abstract class StorageBlockEntity
extends BlockEntity
implements IControllableStorage {
    public static final String STORAGE_WRAPPER_TAG = "storageWrapper";
    private final StorageWrapper storageWrapper;
    @Nullable
    protected Component displayName = null;
    private boolean updateBlockRender = false;
    private IDynamicRenderTracker dynamicRenderTracker = IDynamicRenderTracker.NOOP;
    @Nullable
    private BlockPos controllerPos = null;
    private boolean isDroppingContents = false;
    private boolean chunkBeingUnloaded = false;

    protected abstract ContainerOpenersCounter getOpenersCounter();

    protected StorageBlockEntity(BlockPos pos, BlockState state, BlockEntityType<? extends StorageBlockEntity> blockEntityType) {
        super(blockEntityType, pos, state);
        this.storageWrapper = new StorageWrapper(() -> () -> ((StorageBlockEntity)this).m_6596_(), () -> WorldHelper.notifyBlockUpdate((BlockEntity)this), () -> {
            this.m_6596_();
            WorldHelper.notifyBlockUpdate((BlockEntity)this);
        }){

            public Optional<UUID> getContentsUuid() {
                if (this.contentsUuid == null) {
                    this.contentsUuid = UUID.randomUUID();
                    this.save();
                }
                return Optional.of(this.contentsUuid);
            }

            public ItemStack getWrappedStorageStack() {
                BlockPos pos = StorageBlockEntity.this.m_58899_();
                return StorageBlockEntity.this.m_58900_().m_60734_().getCloneItemStack(StorageBlockEntity.this.m_58900_(), (HitResult)new BlockHitResult(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), Direction.DOWN, pos, true), (BlockGetter)StorageBlockEntity.this.m_58904_(), pos, null);
            }

            @Override
            protected void onUpgradeRefresh() {
                Block block;
                if (!StorageBlockEntity.this.isDroppingContents && StorageBlockEntity.this.f_58857_ != null && !((StorageBlockEntity)StorageBlockEntity.this).f_58857_.f_46443_ && (block = StorageBlockEntity.this.m_58900_().m_60734_()) instanceof IStorageBlock) {
                    IStorageBlock storageBlock = (IStorageBlock)block;
                    storageBlock.setTicking(StorageBlockEntity.this.f_58857_, StorageBlockEntity.this.m_58899_(), StorageBlockEntity.this.m_58900_(), !StorageBlockEntity.this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).isEmpty());
                }
            }

            @Override
            public int getDefaultNumberOfInventorySlots() {
                Block block = StorageBlockEntity.this.m_58900_().m_60734_();
                if (block instanceof IStorageBlock) {
                    IStorageBlock storageBlock = (IStorageBlock)block;
                    return storageBlock.getNumberOfInventorySlots();
                }
                return 0;
            }

            @Override
            protected boolean isAllowedInStorage(ItemStack stack) {
                return StorageBlockEntity.this.isAllowedInStorage(stack);
            }

            @Override
            public int getDefaultNumberOfUpgradeSlots() {
                Block block = StorageBlockEntity.this.m_58900_().m_60734_();
                if (block instanceof IStorageBlock) {
                    IStorageBlock storageBlock = (IStorageBlock)block;
                    return storageBlock.getNumberOfUpgradeSlots();
                }
                return 0;
            }
        };
        this.storageWrapper.getRenderInfo().setChangeListener(ri -> this.dynamicRenderTracker.onRenderInfoUpdated((RenderInfo)ri));
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (level.f_46443_) {
            this.dynamicRenderTracker = new DynamicRenderTracker(this);
        }
    }

    public boolean hasDynamicRenderer() {
        return this.dynamicRenderTracker.isDynamicRenderer();
    }

    public boolean isOpen() {
        return this.getOpenersCounter().m_155450_() > 0;
    }

    public Optional<Component> getCustomName() {
        return Optional.ofNullable(this.displayName);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveStorageWrapper(tag);
        this.saveData(tag);
        this.saveControllerPos(tag);
    }

    private void saveStorageWrapper(CompoundTag tag) {
        tag.m_128365_(STORAGE_WRAPPER_TAG, (Tag)this.storageWrapper.save(new CompoundTag()));
    }

    private void saveStorageWrapperClientData(CompoundTag tag) {
        tag.m_128365_(STORAGE_WRAPPER_TAG, (Tag)this.storageWrapper.saveData(new CompoundTag()));
    }

    protected void saveData(CompoundTag tag) {
        if (this.displayName != null) {
            tag.m_128359_("displayName", Component.Serializer.m_130703_((Component)this.displayName));
        }
        if (this.updateBlockRender) {
            tag.m_128379_("updateBlockRender", true);
        }
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_() && this.f_58857_ != null) {
            this.getOpenersCounter().m_155452_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_() && this.f_58857_ != null) {
            this.getOpenersCounter().m_155468_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_ && this.f_58857_ != null) {
            this.getOpenersCounter().m_155476_(this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        Block block;
        if (this.f_58857_ == null || !((block = state.m_60734_()) instanceof StorageBlockBase)) {
            return;
        }
        StorageBlockBase storageBlock = (StorageBlockBase)block;
        Vec3i vec3i = storageBlock.getFacing(state).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadStorageWrapper(tag);
        this.loadData(tag);
        this.loadControllerPos(tag);
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.removeControllerPos();
            this.tryToAddToController();
        }
    }

    private void loadStorageWrapper(CompoundTag tag) {
        NBTHelper.getCompound((CompoundTag)tag, (String)STORAGE_WRAPPER_TAG).ifPresent(this.storageWrapper::load);
    }

    public void onLoad() {
        super.onLoad();
        this.registerWithControllerOnLoad();
    }

    public void loadData(CompoundTag tag) {
        this.displayName = NBTHelper.getComponent((CompoundTag)tag, (String)"displayName").orElse(null);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            if (tag.m_128471_("updateBlockRender")) {
                WorldHelper.notifyBlockUpdate((BlockEntity)this);
            }
        } else {
            this.updateBlockRender = true;
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void m_7651_() {
        if (!this.chunkBeingUnloaded && this.f_58857_ != null) {
            this.removeFromController();
        }
        super.m_7651_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag == null) {
            return;
        }
        this.loadStorageWrapper(tag);
        this.loadData(tag);
    }

    public void setUpdateBlockRender() {
        this.updateBlockRender = true;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.saveStorageWrapperClientData(tag);
        this.saveData(tag);
        return tag;
    }

    public static void serverTick(Level level, BlockPos blockPos, StorageBlockEntity storageBlockEntity) {
        storageBlockEntity.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(null, level, blockPos));
    }

    public StorageWrapper getStorageWrapper() {
        return this.storageWrapper;
    }

    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.m_58900_().m_60734_().m_49954_();
    }

    protected boolean isAllowedInStorage(ItemStack stack) {
        return true;
    }

    public void increaseStorageSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        int currentInventorySlots = this.getStorageWrapper().getInventoryHandler().getSlots();
        this.getStorageWrapper().increaseSize(additionalInventorySlots, additionalUpgradeSlots);
        if (additionalInventorySlots > 0) {
            this.changeSlots(currentInventorySlots + additionalInventorySlots);
        }
    }

    public void dropContents() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.isDroppingContents = true;
        InventoryHelper.dropItems((ItemStackHandler)this.storageWrapper.getInventoryHandler(), (Level)this.f_58857_, (BlockPos)this.f_58858_);
        InventoryHelper.dropItems((ItemStackHandler)this.storageWrapper.getUpgradeHandler(), (Level)this.f_58857_, (BlockPos)this.f_58858_);
        this.isDroppingContents = false;
    }

    public void setCustomName(Component customName) {
        this.displayName = customName;
        this.m_6596_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(this.getStorageWrapper()::getInventoryForInputOutput).cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean shouldDropContents() {
        return true;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.m_6596_();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public void removeControllerPos() {
        this.controllerPos = null;
    }

    public BlockPos getStorageBlockPos() {
        return this.m_58899_();
    }

    public Level getStorageBlockLevel() {
        return Objects.requireNonNull(this.m_58904_());
    }
}

